//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 0.4;

#include "colors.inc"


  camera {
    location <-10, 8, -19>
    look_at <0, 0, 0>
    angle 50
    }
    
    
background { color rgb <0.2, 0.4, 0.8> }

light_source { <20, 19, -20> color rgb 1/*20
  spotlight
  point_at <0,0,0>
  radius 3
  falloff 3.1
  fade_power 2
  fade_distance 10*/
}

plane {y, -5
pigment {color White}
}

sphere {<0, 0, 0>, 5
  pigment {color rgbf <1, 1, 1, 1>}
  interior {
    media {
      scattering {1, .4 extinction .4}
      #if(0)
        method 2
        samples 2, 2
        intervals 4
        jitter 0
      #else
        method 3
        samples 6,6
        intervals 1
        aa_threshold .1
        aa_level 2
      #end
      jitter 0
      
      absorption 0.1*<1, 1, .5>*0
      density {
        spherical
        turbulence 1.2
        color_map {
          [0 color rgb <0, 0, 0>]
          [1 color rgb <.5, .5, 1>]
        }
        scale 3
      }
    }
  }
  translate 5*x
  hollow
}

sphere {<0, 0, 0>, 5
  pigment {color rgbf <1, 1, 1, 1>}

  interior {
    media {
      scattering {1, .4 extinction .4}

      method 2
      samples 2, 2
      intervals 4
      jitter 0
      
      absorption 0.1*<1, 1, .5>*0
      density {
        spherical
        turbulence 1.2
        color_map {
          [0 color rgb <0, 0, 0>]
          [1 color rgb <.5, .5, 1>]
        }
        scale 3
      }
    }
  }
  translate -5*x
  hollow
}
